﻿<%@ Control Language="C#" %>
<%@ Import Namespace="Kesion.Cache" %>
<%@ Import Namespace="Kesion.Publics" %>
<%@ Import Namespace="Kesion.BLL" %>
<%@ Import Namespace="Kesion.Config" %>
<%@ Import Namespace="Kesion.Components" %>
<%@ Import Namespace="Kesion.HtmlTags" %>
<%@ Import Namespace="System.Data" %>
<%@ Import Namespace="Kesion.Course" %>
<script runat="server" type="text/C#">

    dynamic __user = HttpContext.Current.Items["user"];                   //初始化当前用户信息
    private static dynamic __info = new System.Dynamic.ExpandoObject();   //初始化当前页信息
    public string coursetable = "KS_Course";
    public int ordertype = 0;
    ConfigInfo __configinfo = null;
    public int schoolID = 0;
    public string myTemplateId = "";
    protected void Page_Load(object sender, EventArgs e)
    {
        __configinfo = ConfigManage.Deserialize(Server.MapPath("/config/general.config"));
        if (KSCMS.S("coursetype") == "1")
        {
            coursetable = "KS_CourseFace";
        }
        if (new TemporaryVar().GroupID == 4)
        {
            schoolID = new TemporaryVar().SchoolID;
        }
        if (schoolID == 0)
        {
            schoolID = new TemporaryVar().UserID;
        }

        string action = KSCMS.S("action");
        switch(action)
        {
            case "zhannei"://站内信息
                zhannei();
                break;
            case "duanxin"://手机短信
                duanxin();
                break;
            case "youjian"://发送邮件
                youjian();
                break;
        }
    }

    /// <summary>
    /// 根据发达范围，取对应的SQL语句
    /// </summary>
    /// <param name="flag"></param>
    /// <returns></returns>
    private string GetQuerySql(int flag)
    {
        string sqlStr = "";
        switch (flag)
        {
            case 1:  //所有学员
                sqlStr = "select username from KS_User Where GroupID<>3 And GroupID<>4 And schoolID=" + __user.UserID;
                break;
            case 2: //指定班级
                sqlStr = "select * from [KS_CosClassStudent] where roomid =" + Utils.StrToInt(KSCMS.S("classid"));
                break;
            case 3://已报学员已付款
                sqlStr = "select distinct(b.username) as username from KS_COSOrder a  inner join KS_COSOrderItem b on a.OrderID=b.OrderID where b.Business='" + __user.UserName + "' and a.Status=1  " + (Utils.StrToInt(KSCMS.S("courseid")) == 0 ? "" : " and b.courseid=" + Utils.StrToInt(KSCMS.S("courseid"))) + (KSCMS.S("coursetype") == "1" ? "b.ordertype=1" : "");
                break;
            case 4://已报学员未付款
                sqlStr = "select distinct(b.username) as username from KS_COSOrder a  inner join KS_COSOrderItem b on a.OrderID=b.OrderID where b.Business='" + __user.UserName + "' and a.Status=0  " + (Utils.StrToInt(KSCMS.S("courseid")) == 0 ? "" : " and b.courseid=" + Utils.StrToInt(KSCMS.S("courseid"))) + (KSCMS.S("coursetype") == "1" ? "b.ordertype=1" : "");
                break;
            case 5: //指定学员
                string tousername = KSCMS.S("ToUserName");
                tousername = tousername.Replace(",", "','");
                sqlStr = "select username,Email from ks_user where schoolId="+__user.UserID+" And username in('" + tousername + "')";
                break;
        }
        return sqlStr;
    }

    //总的邮件信息
    private void youjian()
    {
        string sendtype = KSCMS.S("sendtype");
        if (KSCMS.S("Subject") == "")
        {
            Msg.Alert("标题不能为空！", KSCMS.GetComeUrl());
            return;
        }
        if (KSCMS.S("MsgContent") == "")
        {
            Msg.Alert("发送内容不能为空！", KSCMS.GetComeUrl());
            return;
        }
        if (KSCMS.S("SenderMail") == "")
        {
            Msg.Alert("发件人的Email不能为空！",KSCMS.GetComeUrl());
            return;
        }
        switch (sendtype)
        {
            case "0"://所有学员
                sendByAllUserEmail();
                break;
            case "1"://指定班级
                sendByClassEMail();
                break;
            case "2"://已报学员已付款
                sendByBuyEMail();
                break;
            case "3"://已报学员未付款
                sendByNOEMail();
                break;
            case "4"://指定学员名称
                sendByUserNameEMail();
                break;
        }
        //Msg.Alert("邮件发送完毕！",KSCMS.);
        return;
    }

    //总的站内信息
    private void zhannei()
    {
        string sendtype = KSCMS.S("sendtype");
        if (KSCMS.S("Subject") == "")
        {
            Msg.Alert("标题不能为空！", KSCMS.GetComeUrl());
            return;
        }
        if (KSCMS.S("MsgContent") == "")
        {
            Msg.Alert("发送内容不能为空！", KSCMS.GetComeUrl());
            return;
        }
        switch (sendtype)
        {
            case "0"://所有学员
                sendByAllMail();
                break;
            case "1"://指定班级
                sendByClassMail();
                break;
            case "2"://已报学员已付款
                sendByBuyMail();
                break;
            case "3"://已报学员未付款
                sendByNoMail();
                break;
            case "4"://指定学员名称
                sendByUserNameMail();
                break;
        }
    }
    //总的发送短信
    private void duanxin() //方法中有记录信息
    {
        string sendtype=KSCMS.S("sendtype");
        //验证  短信余额是否够用~~~
        if (KSCMS.S("MsgContent") == "")
        {
            Msg.Alert("发送内容不能为空！", KSCMS.GetComeUrl());
            return;
        }
        switch (sendtype)
        {
            case "0"://所有学员
                sendByAll();
                break;
            case "1"://指定班级
                sendByclass();
                break;
            case "2"://已报学员已付款
                sendByUserName(true);
                break;
            case "3"://已报学员未付款
                sendByNoMoney();
                break;
            case "4"://指定学员名称
                sendByUserName();
                break;
        }
    }
    /// <summary>
    /// 替换短信内容标签
    /// </summary>
    /// <param name="tp">短信内容</param>
    /// <param name="dr"></param>
    /// <returns></returns>
    public static string ReplaceSMSLabel(string tp, DataRow dr = null)
    {
        #region 替换短信内容标签
        if (dr != null)
        {
            tp = Utils.ReplaceString(tp, "{#UserName}", dr["username"].ToString(), true);
            tp = Utils.ReplaceString(tp, "{#RealName}", string.IsNullOrEmpty(dr["realname"].ToString()) ? dr["username"].ToString() : dr["realname"].ToString(), true);
            tp = Utils.ReplaceString(tp, "{#Sex}", dr["sex"].ToString() == "男" ? "先生" : "女士", true);
        }
        tp = Utils.ReplaceString(tp, "{#UserName}", "", true);
        tp = Utils.ReplaceString(tp, "{#RealName}", "", true);
        tp = Utils.ReplaceString(tp, "{#Sex}", "", true);
        tp = Utils.ReplaceString(tp, "{#SiteName}", MyCache.GetCacheConfig(1), true);
        tp = Utils.ReplaceString(tp, "{#SendDate}", DateTime.Now.ToShortDateString(), true);
        tp = Utils.ReplaceString(tp, "{#SendTime}", DateTime.Now.ToString(), true);
        return tp;
        #endregion
    }

    /// <summary>
    /// 按用户名发送    短信
    /// </summary>
    private void sendByUserName( bool order=false)
    {
        string tousername = KSCMS.S("ToUserName");
        if (order == true)//已报用户已付款 
        {
            using (DataTable dt = DataFactory.GetDataTable(GetQuerySql(3)))
            {
                if (dt.Rows.Count > 0)
                {
                    tousername = null;
                    foreach (DataRow dr in dt.Rows)
                    {
                        if (string.IsNullOrEmpty(tousername))
                        {
                            tousername = dr["username"].ToString();
                        }
                        else
                        {
                            tousername += "," + dr["username"].ToString();
                        }
                    }
                }
                else {
                    Msg.Alert("暂无学员信息！",KSCMS.GetComeUrl());
                    return;
                }
            }
        }
        tousername = tousername.Replace(",", "','");
        DateTime startTime = DateTime.Now;
        KSCMS.W("<div class='message'> <strong><font color='#009900'>正在执行短信发送...</font></strong>");
        int n = 0;
        int s = 0;
        int sent = 0;//已成功发短信
        using (DataTable dt = DataFactoryUser.GetDataTable("select * from ks_user where schoolid="+__user.UserID+" And username in('" + tousername + "')"))
        {
            if (dt.Rows.Count > 0)
            {
                int duanxinshuliang = 0;
                if (__user.GroupID == 3)
                {
                    duanxinshuliang = Utils.StrToInt(DataFactory.GetOnlyValue("select DuanXinTiaoshu from KS_EnterPrise where userid=" + __user.UserID));
                }
                else if (__user.GroupID == 4)
                {
                    duanxinshuliang = Utils.StrToInt(DataFactory.GetOnlyValue("select DuanXinTiaoshu from KS_CosTeacher where field='" + __user.UserName + "'"));
                }
                if (duanxinshuliang > dt.Rows.Count)//当前短信余额数量  够发
                {
                    foreach (DataRow dr in dt.Rows)
                    {
                        if (dr["mobile"].ToString().Length > 0)
                        {
                            string[] ss = { "", "", ""};
                            if (dr != null)
                            {
                                ss[0] = dr["username"].ToString();
                                ss[1] = (string.IsNullOrEmpty(dr["realname"].ToString()) ? dr["username"].ToString() : dr["realname"].ToString());
                                ss[2] = (dr["sex"].ToString() == "男" ? "先生" : "女士");
                            }
                            string json = "{\"UserName\":\"" + ss[0] + "\",\"RealName\":\"" + ss[1] + "\",\"Sex\":\"" + ss[2] + "\",\"SiteName\":\"" + MyCache.GetCacheConfig(1) + "\",\"SendDate\":\"" + DateTime.Now.ToShortDateString() + "\",\"SendTime\":\"" + DateTime.Now.ToString() + "\"}";
                            string rstr = SMSAPI.SendMsg(dr["mobile"].ToString(), ReplaceSMSLabel(KSCMS.S("MsgContent"), dr),json);

                            Kesion.APPCode.Public.AddSmsInfo(dr["mobile"].ToString(), ReplaceSMSLabel(KSCMS.S("MsgContent"), dr), rstr);
                            if (n % 1 == 0)
                            {
                                KSCMS.W("<br/>正在发送[" + dr["username"].ToString() + "]：" + dr["mobile"].ToString() + (rstr == "true" ? " <span style='color:green'>成功</span>" : " <span style='color:red'>失败</span>") + "；");
                                Response.Flush();
                            }
                            if ((KSCMS.S("MsgContent").Length/__configinfo.G3ContetnLength)>1)//长度大于60的时候短信数量加一
                            {
                                n += (KSCMS.S("MsgContent").Length / __configinfo.G3ContetnLength);
                            }
                            if(rstr=="true")
                            {
                                sent++;
                            }
                            n++;
                        }
                        else
                        {
                            KSCMS.W("<br/><span style='color:red'>手机号未填写【" + dr["mobile"].ToString() + "】用户：" + dr["username"].ToString() + "</span>；");
                            s++;
                        }
                    }
                    if (__user.GroupID == 3)
                    {
                        //发送短信条数    更新机构
                        DataFactory.ExecuteNonQuery("update KS_EnterPrise set DuanXinTiaoshu=DuanXinTiaoshu-" + sent + "   where userid=" + __user.UserID);
                        // DataFactory.ExecuteNonQuery("update KS_EnterPrise set DuanXinTiaoshu=DuanXinTiaoshu-" + n + "   where userid=" + __user.UserID);
                    }
                    else if (__user.GroupID == 4)
                    {
                        //发送短信条数   更新教师
                        // DataFactory.ExecuteNonQuery("update KS_CosTeacher set DuanXinTiaoshu=DuanXinTiaoshu-" + n + "   where field='" + __user.UserName + "'");
                        DataFactory.ExecuteNonQuery("update KS_CosTeacher set DuanXinTiaoshu=DuanXinTiaoshu-" +sent + "   where field='" + __user.UserName + "'");
                    }
                }
                else
                {
                    Msg.Alert("您的短信余额不足！还差" + (dt.Rows.Count - duanxinshuliang) + "条！请充值！", BasicField.GetUserUrl("school/UserEpDuanxin"));
                }
            }
            else {
                Msg.Alert("暂无学员可发信息！",KSCMS.GetComeUrl());
                return;
            }
        }
        KSCMS.W("<br/><strong><font color='#009900'>所有用户发送完毕！</font></storng>");
        TimeSpan ts = DateTime.Now - startTime;
        double t = (Convert.ToDouble((ts.Milliseconds)) / 1000);
        if (t == 0) t = 0.0001;

        KSCMS.W(@"<table border=""0"" align=""center"" cellpadding=""0"" cellspacing=""1""  class=""ctable"" width=""100%""><tr align='center' class='tdbg'><td height='22'><strong>恭喜，操作完成！</strong></td></tr>");
        KSCMS.W(@"<tr class='tdbg'><td height='100' valign='top' style='padding:5px'><br>共发送：<font color='#0000ff'>" + n + "</font> 条短信。<br>共耗时：<font color='#0000ff'>" + t.ToString() + "</font> 毫秒。</td></tr>");
        KSCMS.W(@"</table>");
        KSCMS.W("</div>");

        KSCMS.W("<div style='margin:20px;text-align:center'><input type='button' class='button' onclick=history.go(-1)  value='返回上一页'></div>");
        return;
    }
    //全部学员  短信
    private void sendByAll()
    {
        DateTime startTime = DateTime.Now;
        KSCMS.W("<div class='message'> <strong><font color='#009900'>正在执行短信发送...</font></strong>");
        int n = 0;
        int s = 0;
        int sent = 0;//已成功发短信
        using (DataTable dt = DataFactoryUser.GetDataTable(GetQuerySql(1)))
        {
            if (dt.Rows.Count > 0)
            {
                int duanxinshuliang = 0;
                if (__user.GroupID == 3)
                {
                    duanxinshuliang = Utils.StrToInt(DataFactory.GetOnlyValue("select DuanXinTiaoshu from KS_EnterPrise where userid=" + __user.UserID));
                }
                else if (__user.GroupID == 4)
                {
                    duanxinshuliang = Utils.StrToInt(DataFactory.GetOnlyValue("select DuanXinTiaoshu from KS_CosTeacher where field='" + __user.UserName + "'"));
                }
                if (duanxinshuliang > dt.Rows.Count)//当前短信余额数量  够发
                {
                    foreach (DataRow dr in dt.Rows)
                    {
                        string mobile = string.Empty;
                        using (DataTable dtt = DataFactoryUser.GetDataTable("select * from KS_User  where username='" + dr["username"].ToString() + "'"))
                        {
                            DataRow drr = dtt.Rows[0];
                            mobile=drr["mobile"].ToString();
                            if (mobile.Length > 0)
                            {
                                string[] ss = { "", "", ""};
                                if (dr != null)
                                {
                                    ss[0] = drr["username"].ToString();
                                    ss[1] = (string.IsNullOrEmpty(drr["realname"].ToString()) ? drr["username"].ToString() : drr["realname"].ToString());
                                    ss[2] = (drr["sex"].ToString() == "男" ? "先生" : "女士");
                                }
                                string json = "{\"UserName\":\"" + ss[0] + "\",\"RealName\":\"" + ss[1] + "\",\"Sex\":\"" + ss[2] + "\",\"SiteName\":\"" + MyCache.GetCacheConfig(1) + "\",\"SendDate\":\"" + DateTime.Now.ToShortDateString() + "\",\"SendTime\":\"" + DateTime.Now.ToString() + "\"}";
                                string rstr = SMSAPI.SendMsg(mobile, ReplaceSMSLabel(KSCMS.S("MsgContent"), drr),json);
                                Kesion.APPCode.Public.AddSmsInfo(mobile, ReplaceSMSLabel(KSCMS.S("MsgContent"), drr), rstr);
                                if (n % 1 == 0)
                                {
                                    KSCMS.W("<br/>正在发送[" + dr["username"].ToString() + "]：" + mobile + (rstr == "true" ? " <span style='color:green'>成功</span>" : " <span style='color:red'>失败</span>") + "；");
                                    Response.Flush();
                                }
                                if ((KSCMS.S("MsgContent").Length / __configinfo.G3ContetnLength) > 1)//长度大于60的时候短信数量加一
                                {
                                    n += (KSCMS.S("MsgContent").Length / __configinfo.G3ContetnLength);
                                }
                                if (rstr == "true")
                                {
                                    sent++;
                                }
                                n++;
                            }
                            else
                            {
                                KSCMS.W("<br/><span style='color:red'>手机号未填写【" + mobile + "】用户：" + dr["username"].ToString() + "</span>；");
                                s++;
                            }
                        }

                    }
                    if (__user.GroupID == 3)
                    {
                        //发送短信条数    更新机构
                        DataFactory.ExecuteNonQuery("update KS_EnterPrise set DuanXinTiaoshu=DuanXinTiaoshu-" + sent + "   where userid=" + __user.UserID);
                    }
                    else if (__user.GroupID == 4){
                        //发送短信条数   更新教师
                        DataFactory.ExecuteNonQuery("update KS_CosTeacher set DuanXinTiaoshu=DuanXinTiaoshu-" + sent + "   where field='" + __user.UserName + "'");
                    }
                }
                else {
                    Msg.Alert("您的短信余额不足！还差" + (dt.Rows.Count - duanxinshuliang) + "条！请充值", BasicField.GetUserUrl("school/UserEpDuanxin"));
                }
            }
            else
            {
                Msg.Alert("暂无学员可发信息！", KSCMS.GetComeUrl());
                return;
            }
        }
        KSCMS.W("<br/><strong><font color='#009900'>所有用户发送完毕！</font></storng>");
        TimeSpan ts = DateTime.Now - startTime;
        double t = (Convert.ToDouble((ts.Milliseconds)) / 1000);
        if (t == 0) t = 0.0001;
        KSCMS.W(@"<table border=""0"" align=""center"" cellpadding=""0"" cellspacing=""1""  class=""ctable"" width=""100%""><tr align='center' class='tdbg'><td height='22'><strong>恭喜，操作完成！</strong></td></tr>");
        KSCMS.W(@"<tr class='tdbg'><td height='100' valign='top' style='padding:5px'><br>共发送：<font color='#0000ff'>" + n + "</font> 条短信。<br>共耗时：<font color='#0000ff'>" + t.ToString() + "</font> 毫秒。</td></tr>");
        KSCMS.W(@"</table>");
        KSCMS.W("</div>");

        KSCMS.W("<div style='margin:20px;text-align:center'><input type='button' class='button' onclick=history.go(-1)  value='返回上一页'></div>");
        return;
    }
    //根据  班级发送短信
    private void sendByclass()
    {
        string tousername = null;
        using (DataTable dt = DataFactory.GetDataTable(GetQuerySql(2)))
        {
            if (dt.Rows.Count > 0)
            {
                foreach (DataRow dr in dt.Rows)
                {
                    if (string.IsNullOrEmpty(tousername))
                    {
                        tousername = dr["userid"].ToString();
                    }
                    else
                    {
                        tousername += "," + dr["userid"].ToString();
                    }
                }
            }
            else
            {
                Msg.Alert("该班级下没有学员，请重新选择！",KSCMS.GetComeUrl());
                return;
            }
        }
        tousername = tousername.Replace(",", "','");

        DateTime startTime = DateTime.Now;
        KSCMS.W("<div class='message'> <strong><font color='#009900'>正在执行短信发送...</font></strong>");
        int n = 0;
        int s = 0;
        int sent = 0;//已成功短信条数
        using (DataTable dt = DataFactoryUser.GetDataTable("select * from ks_user where userid in('" + tousername + "')"))
        {
            if (dt.Rows.Count > 0)
            {
                int duanxinshuliang = 0;
                if (__user.GroupID == 3)
                {
                    duanxinshuliang = Utils.StrToInt(DataFactory.GetOnlyValue("select DuanXinTiaoshu from KS_EnterPrise where userid=" + __user.UserID));
                }
                else if (__user.GroupID == 4)
                {
                    duanxinshuliang = Utils.StrToInt(DataFactory.GetOnlyValue("select DuanXinTiaoshu from KS_CosTeacher where field='" + __user.UserName + "'"));
                }
                if (duanxinshuliang > dt.Rows.Count)//当前短信余额数量  够发
                {
                    foreach (DataRow dr in dt.Rows)
                    {
                        if (dr["mobile"].ToString().Length > 0)
                        {


                            string[] ss = { "", "", ""};
                            if (dr != null)
                            {
                                ss[0] = dr["username"].ToString();
                                ss[1] = (string.IsNullOrEmpty(dr["realname"].ToString()) ? dr["username"].ToString() : dr["realname"].ToString());
                                ss[2] = (dr["sex"].ToString() == "男" ? "先生" : "女士");
                            }
                            string json = "{\"UserName\":\"" + ss[0] + "\",\"RealName\":\"" + ss[1] + "\",\"Sex\":\"" + ss[2] + "\",\"SiteName\":\"" + MyCache.GetCacheConfig(1) + "\",\"SendDate\":\"" + DateTime.Now.ToShortDateString() + "\",\"SendTime\":\"" + DateTime.Now.ToString() + "\"}";
                            string rstr = SMSAPI.SendMsg(dr["mobile"].ToString(), ReplaceSMSLabel(KSCMS.S("MsgContent"), dr),json);
                            Kesion.APPCode.Public.AddSmsInfo(dr["mobile"].ToString(), ReplaceSMSLabel(KSCMS.S("MsgContent"), dr), rstr);
                            if (n % 1 == 0)
                            {
                                KSCMS.W("<br/>正在发送[" + dr["username"].ToString() + "]：" + dr["mobile"].ToString() + (rstr == "true" ? " <span style='color:green'>成功</span>" : " <span style='color:red'>失败</span>") + "；");
                                Response.Flush();
                            }
                            if ((KSCMS.S("MsgContent").Length / __configinfo.G3ContetnLength) > 1)//长度大于60的时候短信数量加一
                            {
                                n += (KSCMS.S("MsgContent").Length / __configinfo.G3ContetnLength);
                            }
                            if(rstr=="true")
                            {
                                sent++;
                            }
                            n++;
                        }
                        else
                        {
                            KSCMS.W("<br/><span style='color:red'>手机号未填写【" + dr["mobile"].ToString() + "】用户：" + dr["username"].ToString() + "</span>；");
                            s++;
                        }
                    }
                    if (__user.GroupID == 3)
                    {
                        //发送短信条数    更新机构
                        DataFactory.ExecuteNonQuery("update KS_EnterPrise set DuanXinTiaoshu=DuanXinTiaoshu-" + sent + "   where userid=" + __user.UserID);
                    }
                    else if (__user.GroupID == 4)
                    {
                        //发送短信条数   更新教师
                        DataFactory.ExecuteNonQuery("update KS_CosTeacher set DuanXinTiaoshu=DuanXinTiaoshu-" +sent + "   where field='" + __user.UserName + "'");
                    }
                }
                else
                {
                    Msg.Alert("您的短信余额不足！还差" + (dt.Rows.Count - duanxinshuliang) + "条！请充值", BasicField.GetUserUrl("school/UserEpDuanxin"));
                }
            }
            else
            {
                Msg.Alert("暂无学员可发信息！", KSCMS.GetComeUrl());
                return;
            }
        }

        KSCMS.W("<br/><strong><font color='#009900'>所有用户发送完毕！</font></storng>");
        TimeSpan ts = DateTime.Now - startTime;
        double t = (Convert.ToDouble((ts.Milliseconds)) / 1000);
        if (t == 0) t = 0.0001;

        KSCMS.W(@"<table border=""0"" align=""center"" cellpadding=""0"" cellspacing=""1""  class=""ctable"" width=""100%""><tr align='center' class='tdbg'><td height='22'><strong>恭喜，操作完成！</strong></td></tr>");
        KSCMS.W(@"<tr class='tdbg'><td height='100' valign='top' style='padding:5px'><br>共发送：<font color='#0000ff'>" + n + "</font> 条短信。<br>共耗时：<font color='#0000ff'>" + t.ToString() + "</font> 毫秒。</td></tr>");
        KSCMS.W(@"</table>");
        KSCMS.W("</div>");

        KSCMS.W("<div style='margin:20px;text-align:center'><input type='button' class='button' onclick=history.go(-1)  value='返回上一页'></div>");
        return;
    }
    //已报学员  未付款  短信
    private void sendByNoMoney()
    {
        string tousername = null;
        using (DataTable dt = DataFactory.GetDataTable(GetQuerySql(4)))
        {
            if (dt.Rows.Count > 0)
            {
                foreach (DataRow dr in dt.Rows)
                {
                    if (string.IsNullOrEmpty(tousername))
                    {
                        tousername = dr["username"].ToString();
                    }
                    else
                    {
                        tousername += "," + dr["username"].ToString();
                    }
                }
            }
            else
            {
                Msg.Alert("暂无学员可发信息！", KSCMS.GetComeUrl());
                return;
            }
        }
        tousername = tousername.Replace(",", "','");

        DateTime startTime = DateTime.Now;
        KSCMS.W("<div class='message'> <strong><font color='#009900'>正在执行短信发送...</font></strong>");
        int n = 0;
        int s = 0;
        int sent = 0;//已成功发送短信条数
        using (DataTable dt = DataFactoryUser.GetDataTable("select * from ks_user where username in('" + tousername + "')"))
        {
            if (dt.Rows.Count > 0)
            {
                int duanxinshuliang = 0;
                if (__user.GroupID == 3)
                {
                    duanxinshuliang = Utils.StrToInt(DataFactory.GetOnlyValue("select DuanXinTiaoshu from KS_EnterPrise where userid=" + __user.UserID));
                }
                else if (__user.GroupID == 4)
                {
                    duanxinshuliang = Utils.StrToInt(DataFactory.GetOnlyValue("select DuanXinTiaoshu from KS_CosTeacher where field='" + __user.UserName + "'"));
                }
                if (duanxinshuliang > dt.Rows.Count)//当前短信余额数量  够发
                {
                    foreach (DataRow dr in dt.Rows)
                    {
                        if (dr["mobile"].ToString().Length > 0)
                        {
                            string[] ss = { "", "", "" };
                            if (dr != null)
                            {
                                ss[0] = dr["username"].ToString();
                                ss[1] = (string.IsNullOrEmpty(dr["realname"].ToString()) ? dr["username"].ToString() : dr["realname"].ToString());
                                ss[2] = (dr["sex"].ToString() == "男" ? "先生" : "女士");
                            }
                            string json = "{\"UserName\":\"" + ss[0] + "\",\"RealName\":\"" + ss[1] + "\",\"Sex\":\"" + ss[2] + "\",\"SiteName\":\"" + MyCache.GetCacheConfig(1) + "\",\"SendDate\":\"" + DateTime.Now.ToShortDateString() + "\",\"SendTime\":\"" + DateTime.Now.ToString() + "\"}";
                            string rstr = SMSAPI.SendMsg(dr["mobile"].ToString(), ReplaceSMSLabel(KSCMS.S("MsgContent"), dr), json);
                            Kesion.APPCode.Public.AddSmsInfo(dr["mobile"].ToString(), ReplaceSMSLabel(KSCMS.S("MsgContent"), dr), rstr);
                            if (n % 1 == 0)
                            {
                                KSCMS.W("<br/>正在发送[" + dr["username"].ToString() + "]：" + dr["mobile"].ToString() + (rstr == "true" ? " <span style='color:green'>成功</span>" : " <span style='color:red'>失败</span>") + "；");
                                Response.Flush();
                            }
                            if ((KSCMS.S("MsgContent").Length / __configinfo.G3ContetnLength) > 1)//长度大于60的时候短信数量加一
                            {
                                n += (KSCMS.S("MsgContent").Length / __configinfo.G3ContetnLength);
                            }
                            if(rstr=="true")
                            {
                                sent++;
                            }
                            n++;
                        }
                        else
                        {
                            KSCMS.W("<br/><span style='color:red'>手机号未填写【" + dr["mobile"].ToString() + "】用户：" + dr["username"].ToString() + "</span>；");
                            s++;
                        }
                    }
                    if (__user.GroupID == 3)
                    {
                        //发送短信条数    更新机构
                        DataFactory.ExecuteNonQuery("update KS_EnterPrise set DuanXinTiaoshu=DuanXinTiaoshu-" + sent + "   where userid=" + __user.UserID);
                    }
                    else if (__user.GroupID == 4)
                    {
                        //发送短信条数   更新教师
                        DataFactory.ExecuteNonQuery("update KS_CosTeacher set DuanXinTiaoshu=DuanXinTiaoshu-" + sent + "   where field='" + __user.UserName + "'");
                    }
                }
                else
                {
                    Msg.Alert("您的短信余额不足！还差" + (dt.Rows.Count - duanxinshuliang) + "条！请充值", BasicField.GetUserUrl("school/UserEpDuanxin"));
                    return;
                }
            }
            else
            {
                Msg.Alert("暂无学员可发信息！", KSCMS.GetComeUrl());
                return;
            }
        }
        KSCMS.W("<br/><strong><font color='#009900'>所有用户发送完毕！</font></storng>");
        TimeSpan ts = DateTime.Now - startTime;
        double t = (Convert.ToDouble((ts.Milliseconds)) / 1000);
        if (t == 0) t = 0.0001;
        KSCMS.W(@"<table border=""0"" align=""center"" cellpadding=""0"" cellspacing=""1""  class=""ctable"" width=""100%""><tr align='center' class='tdbg'><td height='22'><strong>恭喜，操作完成！</strong></td></tr>");
        KSCMS.W(@"<tr class='tdbg'><td height='100' valign='top' style='padding:5px'><br>共发送：<font color='#0000ff'>" + n + "</font> 条短信。<br>共耗时：<font color='#0000ff'>" + t.ToString() + "</font> 毫秒。</td></tr>");
        KSCMS.W(@"</table>");
        KSCMS.W("</div>");
        KSCMS.W("<div style='margin:20px;text-align:center'><input type='button' class='button' onclick=history.go(-1)  value='返回上一页'></div>");
        return;
    }



    //发送站内信息
    private void sendMail(string toUserName, DataRow dr = null)
    {
        string subject = "";
        string mailcontent = "";
        string senders = __user.UserName;
        string openid = "";
        using (DataTable dt = DataFactory.GetDataTable("select top 1 * from ks_user where username ='" + toUserName + "'"))
        {
            if (dt.Rows.Count > 0)
            {
                DataRow dr1 = dt.Rows[0];
                subject = ReplaceSMSLabel(KSCMS.S("Subject").ToString(), dr1); //标题
                mailcontent = ReplaceSMSLabel(KSCMS.S("MsgContent"), dr1);
                openid = dr1["weixinopenid"].ToString();
            }
        }
        Hashtable ht = new Hashtable();
        ht.Add("SubjectID", 0);
        ht.Add("ToUserName", toUserName);
        ht.Add("FromUserName", senders);
        ht.Add("MsgTitle", subject);
        ht.Add("MsgContactMan", "");
        ht.Add("MsgTel", "");
        ht.Add("MsgMail", "");
        ht.Add("MsgContent", mailcontent);
        ht.Add("RequestInfo", "");
        ht.Add("AddDate", DateTime.Now);
        ht.Add("ReadTF", 0);
        ht.Add("DelTF", 0);
        ht.Add("Verify", 1);
        CommonData.Insert("KS_Message", ht);
        Kesion.Cache.CommonJsonCache.CleanMessageNum(toUserName);    //更新用户新消息数缓存
        if (!string.IsNullOrEmpty(openid)&&KSCMS.S("IsWXNotice")=="1")
        {
            SendToStu(toUserName, openid, subject, mailcontent);
        }
    }


    /// <summary>
    /// 全部学员  站内信息
    /// </summary>
    private void sendByAllMail()
    {
        DateTime startTime = DateTime.Now;
        KSCMS.W("<div class='message'> <strong><font color='#009900'>正在执行发送站内消息...</font></strong>");
        int n = 0;
        using (DataTable dt = DataFactoryUser.GetDataTable(GetQuerySql(1)))
        {
            if (dt.Rows.Count > 0)
            {
                foreach (DataRow dr in dt.Rows)
                {
                    sendMail(dr["username"].ToString());
                    if (n % 1 == 0)
                    {
                        KSCMS.W("<br/>正在发送：" + dr["username"].ToString() + "；");

                        Response.Flush();
                    }
                    n++;
                }
            }
            else
            {
                Msg.Alert("暂无学员可发信息！", KSCMS.GetComeUrl());
                return;
            }
        }
        KSCMS.W("<br/><strong><font color='#009900'>所有用户发送完毕！</font></storng>");
        TimeSpan ts = DateTime.Now - startTime;
        double t = (Convert.ToDouble((ts.Milliseconds)) / 1000);
        if (t == 0) t = 0.0001;
        KSCMS.W(@"<table border=""0"" align=""center"" cellpadding=""0"" cellspacing=""1""  class=""ctable"" width=""100%""><tr align='center' class='tdbg'><td height='22'><strong>恭喜，操作完成！</strong></td></tr>");
        KSCMS.W(@"  <tr class='tdbg'><td height='100' valign='top' style='padding:5px'><br>共发送：<font color='#0000ff'>" + n + "</font> 条短信。<br>共耗时：<font color='#0000ff'>" + t.ToString() + "</font> 毫秒。</td></tr>");
        KSCMS.W(@"</table>");
        KSCMS.W("</div>");
        KSCMS.W(@"<div style='margin:20px;text-align:center'><input type='button' class='button' onclick=""location.href=history.go(-1);"" value='返回上一页'></div>");
        return;
    }
    /// <summary>
    /// 按班级发送  站内信息
    /// </summary>
    private void sendByClassMail()
    {
        string tousername = string.Empty;
        using (DataTable dt = DataFactory.GetDataTable(GetQuerySql(2)))
        {
            if (dt.Rows.Count > 0)
            {
                foreach (DataRow dr in dt.Rows)
                {
                    if (string.IsNullOrEmpty(tousername))
                    {
                        tousername = dr["userid"].ToString();
                    }
                    else
                    {
                        tousername += "," + dr["userid"].ToString();
                    }
                }
            }
            else
            {
                Msg.Alert("该班级下没有学员，请重新选择！");
                return;
            }
        }
        tousername = tousername.Replace(",", "','");

        DateTime startTime = DateTime.Now;
        KSCMS.W("<div class='message'> <strong><font color='#009900'>正在执行发送站内消息...</font></strong>");
        int n = 0;
        using (DataTable dt = DataFactoryUser.GetDataTable("select * from ks_user where userid in ('" + tousername + "') order by userid "))
        {
            if (dt.Rows.Count > 0)
            {
                foreach (DataRow dr in dt.Rows)
                {
                    sendMail(dr["username"].ToString());
                    if (n % 1 == 0)
                    {
                        KSCMS.W("<br/>正在发送：" + dr["username"].ToString() + "；");
                        Response.Flush();
                    }
                    n++;
                }
            }
            else
            {
                Msg.Alert("暂无学员可发信息！", KSCMS.GetComeUrl());
                return;
            }
        }
        KSCMS.W("<br/><strong><font color='#009900'>所有用户发送完毕！</font></storng>");
        TimeSpan ts = DateTime.Now - startTime;
        double t = (Convert.ToDouble((ts.Milliseconds)) / 1000);
        if (t == 0) t = 0.0001;
        KSCMS.W(@"<table border=""0"" align=""center"" cellpadding=""0"" cellspacing=""1""  class=""ctable"" width=""100%""><tr align='center' class='tdbg'><td height='22'><strong>恭喜，操作完成！</strong></td></tr>");
        KSCMS.W(@"  <tr class='tdbg'><td height='100' valign='top' style='padding:5px'><br>共发送：<font color='#0000ff'>" + n + "</font> 条短信。<br>共耗时：<font color='#0000ff'>" + t.ToString() + "</font> 毫秒。</td></tr>");
        KSCMS.W(@"</table>");
        KSCMS.W("</div>");
        KSCMS.W(@"<div style='margin:20px;text-align:center'><input type='button' class='button' onclick=""location.href=history.go(-1);"" value='返回上一页'></div>");
        return;
    }
    /// <summary>
    /// 按用户名发送
    /// </summary>
    private void sendByUserNameMail()
    {
        using (DataTable dt = DataFactoryUser.GetDataTable(GetQuerySql(5)))
        {
            if (dt.Rows.Count > 0)
            {
                foreach (DataRow dr in dt.Rows)
                {
                    sendMail(dr["username"].ToString());
                }
            }
            else
            {
                Msg.Alert("暂无学员可发信息！", KSCMS.GetComeUrl());
                return;
            }
        }
        Msg.Alert("恭喜，发送成功！", KSCMS.GetComeUrl());
    }
    //发送已报  未付款
    private void sendByNoMail()
    {
        string tousername = string.Empty;
        using (DataTable dt = DataFactory.GetDataTable(GetQuerySql(4)))
        {
            if (dt.Rows.Count > 0)
            {
                foreach (DataRow dr in dt.Rows)
                {
                    if (string.IsNullOrEmpty(tousername))
                    {
                        tousername = dr["username"].ToString();
                    }
                    else
                    {
                        tousername += "," + dr["username"].ToString();
                    }
                }
            }
            else
            {
                Msg.Alert("暂无学员可发信息！", KSCMS.GetComeUrl());
                return;
            }
        }
        tousername = tousername.Replace(",", "','");

        DateTime startTime = DateTime.Now;
        KSCMS.W("<div class='message'> <strong><font color='#009900'>正在执行发送站内消息...</font></strong>");
        int n = 0;
        using (DataTable dt = DataFactoryUser.GetDataTable("select * from ks_user where username in('" + tousername + "')"))
        {
            if (dt.Rows.Count > 0)
            {
                foreach (DataRow dr in dt.Rows)
                {
                    sendMail(dr["username"].ToString());
                    if (n % 1 == 0)
                    {
                        KSCMS.W("<br/>正在发送：" + dr["username"].ToString() + "；");
                        Response.Flush();
                    }
                    n++;
                }
            }
            else
            {
                Msg.Alert("暂无学员可发信息！", KSCMS.GetComeUrl());
                return;
            }
        }
        KSCMS.W("<br/><strong><font color='#009900'>所有用户发送完毕！</font></storng>");
        TimeSpan ts = DateTime.Now - startTime;
        double t = (Convert.ToDouble((ts.Milliseconds)) / 1000);
        if (t == 0) t = 0.0001;
        KSCMS.W(@"<table border=""0"" align=""center"" cellpadding=""0"" cellspacing=""1""  class=""ctable"" width=""100%""><tr align='center' class='tdbg'><td height='22'><strong>恭喜，操作完成！</strong></td></tr>");
        KSCMS.W(@"  <tr class='tdbg'><td height='100' valign='top' style='padding:5px'><br>共发送：<font color='#0000ff'>" + n + "</font> 条短信。<br>共耗时：<font color='#0000ff'>" + t.ToString() + "</font> 毫秒。</td></tr>");
        KSCMS.W(@"</table>");
        KSCMS.W("</div>");
        KSCMS.W(@"<div style='margin:20px;text-align:center'><input type='button' class='button' onclick=""location.href=history.go(-1);"" value='返回上一页'></div>");
        return;
    }
    //发送已报  已付款
    private void sendByBuyMail()
    {
        string tousername = string.Empty;
        using (DataTable dt = DataFactory.GetDataTable(GetQuerySql(3)))
        {
            if (dt.Rows.Count > 0)
            {
                foreach (DataRow dr in dt.Rows)
                {
                    if (string.IsNullOrEmpty(tousername))
                    {
                        tousername = dr["username"].ToString();
                    }
                    else
                    {
                        tousername += "," + dr["username"].ToString();
                    }
                }
            }
            else
            {
                Msg.Alert("暂无学员信息！", KSCMS.GetComeUrl());
                return;
            }
        }
        tousername = tousername.Replace(",", "','");
        DateTime startTime = DateTime.Now;
        KSCMS.W("<div class='message'> <strong><font color='#009900'>正在执行发送站内消息...</font></strong>");
        int n = 0;
        using (DataTable dt = DataFactoryUser.GetDataTable("select * from ks_user where username  in('" + tousername + "')"))
        {
            if (dt.Rows.Count > 0)
            {
                foreach (DataRow dr in dt.Rows)
                {
                    sendMail(dr["username"].ToString());
                    if (n % 1 == 0)
                    {
                        KSCMS.W("<br/>正在发送：" + dr["username"].ToString() + "；");
                        Response.Flush();
                    }
                    n++;
                }
            }
            else
            {
                Msg.Alert("暂无学员可发信息！", KSCMS.GetComeUrl());
                return;
            }
        }
        KSCMS.W("<br/><strong><font color='#009900'>所有用户发送完毕！</font></storng>");
        TimeSpan ts = DateTime.Now - startTime;
        double t = (Convert.ToDouble((ts.Milliseconds)) / 1000);
        if (t == 0) t = 0.0001;
        KSCMS.W(@"<table border=""0"" align=""center"" cellpadding=""0"" cellspacing=""1""  class=""ctable"" width=""100%""><tr align='center' class='tdbg'><td height='22'><strong>恭喜，操作完成！</strong></td></tr>");
        KSCMS.W(@"  <tr class='tdbg'><td height='100' valign='top' style='padding:5px'><br>共发送：<font color='#0000ff'>" + n + "</font> 条短信。<br>共耗时：<font color='#0000ff'>" + t.ToString() + "</font> 毫秒。</td></tr>");
        KSCMS.W(@"</table>");
        KSCMS.W("</div>");
        KSCMS.W(@"<div style='margin:20px;text-align:center'><input type='button' class='button' onclick=""location.href=history.go(-1);"" value='返回上一页'></div>");
        return;
    }
    //发送邮件信息    不记录
    private string sendEMail(string mailto, DataRow dr = null)
    {
        string subject = ReplaceSMSLabel(KSCMS.S("Subject").Trim(), dr);
        string senders = KSCMS.S("Sender").Trim();
        string mailfrom = KSCMS.S("SenderMail").Trim();
        string mailcontent = ReplaceSMSLabel(KSCMS.S("MsgContent").Trim(), dr);
        int priority = 3;

        if (mailto.ToLower().IndexOf("hotmail.com") >= 0)  //发送给hotmail时，不支持html编辑器
        {
            mailcontent = Utils.ClearHtml(mailcontent);
        }
        string MailResult = EmailService.SendMailMsg(MyCache.GetCacheConfig(23), MyCache.GetCacheConfig(24), MyCache.GetCacheConfig(8), mailto, subject, mailcontent, MyCache.GetCacheConfig(25), Utils.StrToInt(MyCache.GetCacheConfig(26)), priority);
        return MailResult;
    }
    /// <summary>
    /// 所有用户
    /// </summary>
    private void sendByAllUserEmail()
    {
        DateTime startTime = DateTime.Now;
        KSCMS.W("<div class='message'> <strong><font color='#009900'>正在执行发送电子邮件...</font></strong>");
        int n = 0;
        int s = 0;
        using (DataTable dt = DataFactoryUser.GetDataTable(GetQuerySql(1)))
        {
            if (dt.Rows.Count > 0)
            {
                foreach (DataRow dr in dt.Rows)
                {
                    string email = string.Empty;
                    using (DataTable dtt = DataFactoryUser.GetDataTable("select * from KS_User  where username='" + dr["username"].ToString() + "'"))
                    {
                        if (dtt.Rows.Count > 0)
                        {
                            DataRow drr = dtt.Rows[0];
                            email = drr["email"].ToString();
                            if (email.Length > 0 && Utils.IsValidEmail(email))
                            {
                                string rstr = sendEMail(email);
                                if (n % 1 == 0)
                                {
                                    KSCMS.W("<br/>正在发送：" + email + (rstr == "success" ? " <span style='color:green'>成功</span>" : " <span style='color:red'>失败</span>") + "；");
                                    Response.Flush();
                                }
                                n++;
                            }
                            else
                            {
                                KSCMS.W("<br/><span style='color:red'>邮件格式不正确【" + email + "】用户：" + dr["username"].ToString() + "</span>；");
                                s++;
                            }
                        }
                    }
                }
            }
            else
            {
                Msg.Alert("暂无学员可发信息！", KSCMS.GetComeUrl());
                return;
            }
        }
        KSCMS.W("<br/><strong><font color='#009900'>所有用户发送完毕！</font></storng>");
        TimeSpan ts = DateTime.Now - startTime;
        double t = (Convert.ToDouble((ts.Milliseconds)) / 1000);
        if (t == 0) t = 0.0001;
        KSCMS.W(@"<table border=""0"" align=""center"" cellpadding=""0"" cellspacing=""1""  class=""ctable"" width=""100%""><tr align='center' class='tdbg'><td height='22'><strong>恭喜，操作完成！</strong></td></tr>");
        KSCMS.W(@"  <tr class='tdbg'><td height='100' valign='top' style='padding:5px'><br>共发送成功：<font color='#0000ff'>" + n + "</font> 条邮件。发送失败：<font color='red'>" + s + "条</font> <br>共耗时：<font color='#0000ff'>" + t.ToString() + "</font> 毫秒。</td></tr>");
        KSCMS.W(@"</table>");
        KSCMS.W("</div>");
        KSCMS.W(@"<div style='margin:20px;text-align:center'><input type='button' class='button' onclick=""history.back()"" value='返回上一页'></div>");
        return;
    }
    /// <summary>
    /// 按班级发送邮件
    /// </summary>
    private void sendByClassEMail()
    {
        string tousername = null;
        using (DataTable dt = DataFactory.GetDataTable(GetQuerySql(2)))
        {
            if (dt.Rows.Count > 0)
            {
                foreach (DataRow dr in dt.Rows)
                {
                    if (string.IsNullOrEmpty(tousername))
                    {
                        tousername = dr["userid"].ToString();
                    }
                    else
                    {
                        tousername += "," + dr["userid"].ToString();
                    }
                }
            }
            else
            {
                Msg.Alert("该班级下没有学员，请重新选择！",KSCMS.GetComeUrl());
                return;
            }
        }

        DateTime startTime = DateTime.Now;
        KSCMS.W("<div class='message'> <strong><font color='#009900'>正在执行发送电子邮件...</font></strong>");
        int n = 0;
        int s = 0;
        using (DataTable dt = DataFactoryUser.GetDataTable("select * from ks_user where userid in('" + Utils.FilterIDs(tousername) + "')"))
        {
            if (dt.Rows.Count > 0)
            {
                foreach (DataRow dr in dt.Rows)
                {
                    if (dr["email"].ToString().Length > 0 && Utils.IsValidEmail(dr["email"].ToString()))
                    {
                        string rstr = sendEMail(dr["email"].ToString(), dr);
                        if (n % 1 == 0)
                        {
                            KSCMS.W("<br/>正在发送：" + dr["email"].ToString() + (rstr == "success" ? " <span style='color:green'>成功</span>" : " <span style='color:red'>失败</span>") + "；");
                            Response.Flush();
                        }
                        n++;
                    }
                    else
                    {
                        KSCMS.W("<br/><span style='color:red'>邮件格式不正确【" + dr["email"].ToString() + "】用户：" + dr["username"].ToString() + "</span>；");
                        s++;
                    }
                }
            }
            else
            {
                Msg.Alert("暂无学员可发信息！", KSCMS.GetComeUrl());
                return;
            }
        }
        KSCMS.W("<br/><strong><font color='#009900'>所有用户发送完毕！</font></storng>");
        TimeSpan ts = DateTime.Now - startTime;
        double t = (Convert.ToDouble((ts.Milliseconds)) / 1000);
        if (t == 0) t = 0.0001;
        KSCMS.W(@"<table border=""0"" align=""center"" cellpadding=""0"" cellspacing=""1""  class=""ctable"" width=""100%""><tr align='center' class='tdbg'><td height='22'><strong>恭喜，操作完成！</strong></td></tr>");
        KSCMS.W(@"  <tr class='tdbg'><td height='100' valign='top' style='padding:5px'><br>共发送：<font color='#0000ff'>" + n + "</font> 条邮件。<br>共耗时：<font color='#0000ff'>" + t.ToString() + "</font> 毫秒。</td></tr>");
        KSCMS.W(@"</table>");
        KSCMS.W("</div>");
        KSCMS.W(@"<div style='margin:20px;text-align:center'><input type='button' class='button' onclick=""history.back()"" value='返回上一页'></div>");
        return;
    }
    /// <summary>
    /// 已报   已付款
    /// </summary>
    private void sendByBuyEMail()
    {
        string tousername = null;
        using (DataTable dt = DataFactory.GetDataTable(GetQuerySql(3)))
        {
            if (dt.Rows.Count > 0)
            {
                foreach (DataRow dr in dt.Rows)
                {
                    if (string.IsNullOrEmpty(tousername))
                    {
                        tousername = dr["username"].ToString();
                    }
                    else
                    {
                        tousername += "," + dr["username"].ToString();
                    }
                }
            }
            else
            {
                Msg.Alert("暂无学员信息！", KSCMS.GetComeUrl());
                return;
            }
        }
        tousername = tousername.Replace(",", "','");

        DateTime startTime = DateTime.Now;
        KSCMS.W("<div class='message'> <strong><font color='#009900'>正在执行发送电子邮件...</font></strong>");
        int n = 0;
        int s = 0;
        using (DataTable dt = DataFactoryUser.GetDataTable("select * from ks_user where username in('" + tousername + "')"))
        {
            if (dt.Rows.Count > 0)
            {
                foreach (DataRow dr in dt.Rows)
                {
                    if (dr["email"].ToString().Length > 0 && Utils.IsValidEmail(dr["email"].ToString()))
                    {
                        string rstr = sendEMail(dr["email"].ToString(), dr);
                        if (n % 1 == 0)
                        {
                            KSCMS.W("<br/>正在发送：" + dr["email"].ToString() + (rstr == "success" ? " <span style='color:green'>成功</span>" : " <span style='color:red'>失败</span>") + "；");
                            Response.Flush();
                        }
                        n++;
                    }
                    else
                    {
                        KSCMS.W("<br/><span style='color:red'>邮件格式不正确【" + dr["email"].ToString() + "】用户：" + dr["username"].ToString() + "</span>；");
                        s++;
                    }
                }
            }
            else
            {
                Msg.Alert("暂无学员可发信息！", KSCMS.GetComeUrl());
                return;
            }
        }
        KSCMS.W("<br/><strong><font color='#009900'>所有用户发送完毕！</font></storng>");
        TimeSpan ts = DateTime.Now - startTime;
        double t = (Convert.ToDouble((ts.Milliseconds)) / 1000);
        if (t == 0) t = 0.0001;
        KSCMS.W(@"<table border=""0"" align=""center"" cellpadding=""0"" cellspacing=""1""  class=""ctable"" width=""100%""><tr align='center' class='tdbg'><td height='22'><strong>恭喜，操作完成！</strong></td></tr>");
        KSCMS.W(@"  <tr class='tdbg'><td height='100' valign='top' style='padding:5px'><br>共发送：<font color='#0000ff'>" + n + "</font> 条邮件。<br>共耗时：<font color='#0000ff'>" + t.ToString() + "</font> 毫秒。</td></tr>");
        KSCMS.W(@"</table>");
        KSCMS.W("</div>");
        KSCMS.W(@"<div style='margin:20px;text-align:center'><input type='button' class='button' onclick=""history.back()"" value='返回上一页'></div>");
        return;
    }
    /// <summary>
    /// 已报   未付款
    /// </summary>
    private void sendByNOEMail()
    {
        string tousername = null;
        using (DataTable dt = DataFactory.GetDataTable(GetQuerySql(4)))
        {
            if (dt.Rows.Count > 0)
            {
                foreach (DataRow dr in dt.Rows)
                {
                    if (string.IsNullOrEmpty(tousername))
                    {
                        tousername = dr["username"].ToString();
                    }
                    else
                    {
                        tousername += "," + dr["username"].ToString();
                    }
                }
            }
            else
            {
                Msg.Alert("暂无学员信息！", KSCMS.GetComeUrl());
                return;
            }
        }
        tousername = tousername.Replace(",", "','");

        DateTime startTime = DateTime.Now;
        KSCMS.W("<div class='message'> <strong><font color='#009900'>正在执行发送电子邮件...</font></strong>");
        int n = 0;
        int s = 0;
        using (DataTable dt = DataFactoryUser.GetDataTable("select * from ks_user where username in('" + tousername + "')"))
        {
            if (dt.Rows.Count > 0)
            {
                foreach (DataRow dr in dt.Rows)
                {
                    if (dr["email"].ToString().Length > 0 && Utils.IsValidEmail(dr["email"].ToString()))
                    {
                        string rstr = sendEMail(dr["email"].ToString(), dr);
                        if (n % 1 == 0)
                        {
                            KSCMS.W("<br/>正在发送：" + dr["email"].ToString() + (rstr == "success" ? " <span style='color:green'>成功</span>" : " <span style='color:red'>失败</span>") + "；");
                            Response.Flush();
                        }
                        n++;
                    }
                    else
                    {
                        KSCMS.W("<br/><span style='color:red'>邮件格式不正确【" + dr["email"].ToString() + "】用户：" + dr["username"].ToString() + "</span>；");
                        s++;
                    }
                }
            }
            else
            {
                Msg.Alert("暂无学员可发信息！", KSCMS.GetComeUrl());
                return;
            }
        }
        KSCMS.W("<br/><strong><font color='#009900'>所有用户发送完毕！</font></storng>");
        TimeSpan ts = DateTime.Now - startTime;
        double t = (Convert.ToDouble((ts.Milliseconds)) / 1000);
        if (t == 0) t = 0.0001;
        KSCMS.W(@"<table border=""0"" align=""center"" cellpadding=""0"" cellspacing=""1""  class=""ctable"" width=""100%""><tr align='center' class='tdbg'><td height='22'><strong>恭喜，操作完成！</strong></td></tr>");
        KSCMS.W(@"  <tr class='tdbg'><td height='100' valign='top' style='padding:5px'><br>共发送：<font color='#0000ff'>" + n + "</font> 条邮件。<br>共耗时：<font color='#0000ff'>" + t.ToString() + "</font> 毫秒。</td></tr>");
        KSCMS.W(@"</table>");
        KSCMS.W("</div>");
        KSCMS.W(@"<div style='margin:20px;text-align:center'><input type='button' class='button' onclick=""history.back()"" value='返回上一页'></div>");
        return;
    }
    /// <summary>
    /// 按用户名发送
    /// </summary>
    private void sendByUserNameEMail()
    {
        DateTime startTime = DateTime.Now;
        KSCMS.W("<div class='message'> <strong><font color='#009900'>正在执行发送电子邮件...</font></strong>");
        int n = 0;
        int s = 0;
        using (DataTable dt = DataFactoryUser.GetDataTable(GetQuerySql(5)))
        {
            if (dt.Rows.Count > 0)
            {
                foreach (DataRow dr in dt.Rows)
                {
                    if (dr["email"].ToString().Length > 0 && Utils.IsValidEmail(dr["email"].ToString()))
                    {
                        string rstr = sendEMail(dr["email"].ToString(), dr);
                        if (n % 1 == 0)
                        {
                            KSCMS.W("<br/>正在发送：" + dr["email"].ToString() + (rstr == "success" ? " <span style='color:green'>成功</span>" : " <span style='color:red'>失败</span>") + "；");
                            Response.Flush();
                        }
                        n++;
                    }
                    else
                    {
                        KSCMS.W("<br/><span style='color:red'>邮件格式不正确【" + dr["email"].ToString() + "】用户：" + dr["username"].ToString() + "</span>；");
                        s++;
                    }
                }
            }
            else
            {
                Msg.Alert("暂无学员可发信息！", KSCMS.GetComeUrl());
                return;
            }
        }
        KSCMS.W("<br/><strong><font color='#009900'>所有用户发送完毕！</font></storng>");
        TimeSpan ts = DateTime.Now - startTime;
        double t = (Convert.ToDouble((ts.Milliseconds)) / 1000);
        if (t == 0) t = 0.0001;
        KSCMS.W(@"<table border=""0"" align=""center"" cellpadding=""0"" cellspacing=""1""  class=""ctable"" width=""100%""><tr align='center' class='tdbg'><td height='22'><strong>恭喜，操作完成！</strong></td></tr>");
        KSCMS.W(@"  <tr class='tdbg'><td height='100' valign='top' style='padding:5px'><br>共发送：<font color='#0000ff'>" + n + "</font> 条邮件。<br>共耗时：<font color='#0000ff'>" + t.ToString() + "</font> 毫秒。</td></tr>");
        KSCMS.W(@"</table>");
        KSCMS.W("</div>");
        KSCMS.W(@"<div style='margin:20px;text-align:center'><input type='button' class='button' onclick=""history.back()"" value='返回上一页'></div>");
        return;
    }
    public void SendToStu(string UserName,string OpenID,string Title,string Content)
    {
        #region 微信发送学员通知

        if (!string.IsNullOrEmpty(OpenID) && CommonJsonCache.CheckYunAPPHasAllow("plus.weixin"))
        {
            myTemplateId = DataFactory.GetOnlyValue("select top 1 mytemplateid from KS_weixineptemplate where userid=" + schoolID + " and orderid=2 and enable=1");

            string Data = string.Format(@"
                                               ""data"":{{
                                                       ""first"": {{
                                                           ""value"":""{0}"",
                                                           ""color"":""#173177""
                                                       }},
                                                       ""keyword1"":{{
                                                           ""value"":""{1}"",
                                                           ""color"":""#173177""
                                                       }},
                                                       ""keyword2"": {{
                                                           ""value"":""{2}"",
                                                           ""color"":""#173177""
                                                       }},""keyword3"": {{
                                                           ""value"":""{3}"",
                                                           ""color"":""#173177""
                                                       }},""keyword4"": {{
                                                           ""value"":""{4}"",
                                                           ""color"":""#173177""
                                                       }},
                                                      ""remark"":{{
                                                           ""value"":""{5}"",
                                                           ""color"":""#173177""
                                                       }}
                                               }}
                                           ", Title,"通知", "成功", DateTime.Now, UserName, Content);
            Kesion.Weixin.ks_weixin.SendEpWeixinTemplateMsg(myTemplateId, OpenID, Data,schoolID);
        }
        #endregion
    }

    /// <summary>
    /// 得到SQL语句的查询条件
    /// </summary>
    /// <returns></returns>
    public string GetSqlParam()
    {
        int TcId = 0;
        string sql = "select top 1 tcid from KS_CosTeacher where Field='" + new TemporaryVar().UserName+ "'";
        TcId = Utils.StrToInt(DataFactory.GetOnlyValue(sql));
        string banzhurenid = string.Empty;
        if (__user.GroupID == 4)
        {
            banzhurenid = TcId.ToString();
        }
        else
        {
            using (DataTable dt = DataFactory.GetDataTable("select tcid from KS_CosTeacher where SchoolName='" + new TemporaryVar().UserName + "'"))
            {
                if (dt.Rows.Count > 0)
                {
                    foreach (DataRow dr in dt.Rows)
                    {
                        if (string.IsNullOrEmpty(banzhurenid))
                        {
                            banzhurenid = dr["tcid"].ToString();
                        }
                        else
                        {
                            banzhurenid += "," + dr["tcid"].ToString();
                        }
                    }
                }
                else
                {
                    banzhurenid = "0";
                }
            }
        }
        string sqlParam = " (inputer='" + new TemporaryVar().UserName + "' or schoolID=" + new TemporaryVar().UserID + " or banzhurenid in (" + banzhurenid + ")  or ','+tcid+',' like '%," + banzhurenid + ",%')";
        return sqlParam;

    }
</script>

<%Kesion.APPCode.EditorAPI.EchoHead(); %>
    <%
        if (KSCMS.S("action")==""){ %>

<div class="t_tybox nomar"> 
<div class="tytitle"><h4>发送信息</h4></div>
    <%if(KSCMS.S("type")=="1"){ %>
    <form name="myform" action="{$GetCurrUrl}" method="post" >
     <input type="hidden" name="action" value="zhannei"/>
    <table width="100%" class="border" align="center" border=0 >
       <tr class="title">
            <td colspan="2" style="text-align:left">发送站内信息<%if(Utils.StrToInt(KSCMS.S("courseid"))!=0){ %>(指定课程：<%=DataFactory.GetOnlyValue("select top 1 name from "+coursetable+" where courseid="+Utils.StrToInt(KSCMS.S("courseid"))) %>下的学员信息 )<%} %></td>
       </tr>
        <tr class="tdbg">
	        <td class="lefttd" >收件人选择：</td>
	        <td class="tag_left" style="line-height:32px">
               <input type="radio" name="sendtype" value="0"  onclick="jQuery('#class').hide();"/>所有学员(<span style="color:red"><%=DataFactory.GetOnlyValue("select count(userId) from KS_User Where GroupID<>3 And GroupID<>4 And schoolID="+__user.UserID) %></span>人)<br />
               <input type="radio" name="sendtype" value="1"  onclick="jQuery('#class').show();"/>指定班级 
                    <div  id="class" style="display:none;" >
                        <select name="classid"> 
                    <%
                       // Utils.WriteLog("dddd=select roomid,title  from KS_CosClassRoom where" + GetSqlParam() + "");
                        using (DataTable dt = DataFactory.GetDataTable("select roomid,title  from KS_CosClassRoom where "+GetSqlParam()+""))
                        {
                            if (dt.Rows.Count > 0)
                            {
                                foreach (DataRow dr in dt.Rows)
                                {
                                    KSCMS.W(@"<option value='" + dr["roomid"].ToString() + "'>" + dr["title"].ToString() + "(人数：" + DataFactory.GetOnlyValue("select count(1) from [KS_CosClassStudent] where [RoomID]=" + Utils.StrToInt(dr["roomid"].ToString())) + ")" + "</option>");
                                }
                            }
                            else
                            {
                                KSCMS.W(@"<option value=0>暂无班级</option>");
                            }
                        }
                         %>
                </select>
                    </div><br />
                 <input type="radio" name="sendtype" value="2" onclick="jQuery('#class').hide();" /><%=Utils.StrToInt(KSCMS.S("courseid"))==0?"购买过我的产品（已付款：":"已购买本课程（已付款：" %><span style="color:red"><%=DataFactory.GetOnlyValue(" select count(distinct(b.UserID)) from KS_COSOrder a  inner join KS_COSOrderItem b on a.OrderID=b.OrderID where b.Business='"+__user.UserName+"' and a.Status=1  "+(Utils.StrToInt(KSCMS.S("courseid"))==0?"":" and b.courseid="+Utils.StrToInt(KSCMS.S("courseid")))) %></span>人)<br />
                 <input type="radio" name="sendtype" value="3" onclick="jQuery('#class').hide();" /><%=Utils.StrToInt(KSCMS.S("courseid"))==0?"购买过我的产品（未付款：":"已购买本课程（未付款：" %><span style="color:red"><%=DataFactory.GetOnlyValue(" select count(distinct(b.UserID)) from KS_COSOrder a  inner join KS_COSOrderItem b on a.OrderID=b.OrderID where b.Business='"+__user.UserName+"' and a.Status=0  "+(Utils.StrToInt(KSCMS.S("courseid"))==0?"":" and b.courseid="+Utils.StrToInt(KSCMS.S("courseid")))) %></span>人)<br />
                 <input type="radio" name="sendtype" value="4" onclick="jQuery('#class').hide();" checked />指定学员
                <input type="text" name="ToUserName" id="ToUserName" maxlength="220" class="textbox" value="" /><font color=red>*</font> 
                <span class="tips">多个收件人请用英文逗号隔开。</span>
                </td>
        </tr>
        <tr class="tdbg">
	        <td class="lefttd">标　题：</td>
	        <td class="tag_left">
                <input type="text" name="Subject" id="Subject" maxlength="220" class="textbox" value=""/><font color=red>*</font> 
                </td>
        </tr>
        <tr class="tdbg">
	        <td class="lefttd">内　容：  </td>
	        <td class="tag_left">
            <textarea name="MsgContent" rows="3" cols="3" id="MsgContent" style="width:95%;height:150px"></textarea>
             <%Kesion.APPCode.EditorAPI.EchoEditor("editor", "MsgContent", "Basic",0,true,true,true,false,false);%>
            </td>
        </tr>
          <%if (CommonJsonCache.CheckYunAPPHasAllow("plus.weixin") && DataFactory.GetOnlyValue("select top 1 verify from ks_weixinuser where userid=" + schoolID + "")=="1") { %>
             <tr>
			 <td align="right" class="lefttd" height="30" style="width: 102px"><strong>是否微信提醒：</strong></td>
			 <td class="tag_left">
				 <table id="IsWXNotice" border="0" style="height:24px;width:190px;">
		<tr>
            <td class="bo-min"><input id="IsWXNotice_1" type="radio"  class="radiobtn" name="IsWXNotice" value="0" checked="checked"  />否</td>
			<td class="bo-min"><input id="IsWXNotice_0" type="radio" class="radiobtn" name="IsWXNotice" value="1" />是</td>
		</tr>
	</table>
			 </td>
		 </tr>
             <%} %>
        <tr class="tdbg">
         <td class="lefttd"></td>
         <td height="50" class="tag_left">  <input type="submit" ID="BtnSend" class="ty_button button" value="发 送" onclick="return (CheckForm())"  / style="margin-left:0"></td>
        </tr>
        </table>   
       <br />

    </form>
    <%}else if(KSCMS.S("type")=="2"){ %>
    <form name="myform" action="{$GetCurrUrl}" method="post" >
     <input type="hidden" name="action" value="duanxin"/>
    <table width="98%" class="border" align="center" border=0 >
       <tr class="title" >
            <td colspan="2" style="text-align:left">发送短信信息<%if(Utils.StrToInt(KSCMS.S("courseid"))!=0){ %>(指定课程：<%=DataFactory.GetOnlyValue("select top 1 name from KS_Course where courseid="+Utils.StrToInt(KSCMS.S("courseid"))) %>下的学员信息 )<%} %>
                <%
                    int DuanXinTiaoshu = 0;
                    if (__user.GroupID == 3)
                    {
                        DuanXinTiaoshu = Utils.StrToInt(DataFactory.GetOnlyValue("select top 1 DuanXinTiaoshu from KS_EnterPrise where userid=" + UserManage.GetUserInfo().UserID));
                    }
                    else if (__user.GroupID == 4)
                    {

                        DuanXinTiaoshu = Utils.StrToInt(DataFactory.GetOnlyValue("select top 1 DuanXinTiaoshu from KS_CosTeacher where field='" + UserManage.GetUserInfo().UserName+"'"));
                    }
                %>
                <span style="float:right">当前可用短信<font color="red" style=" font-size:20px; margin-left:5px;"><%= DuanXinTiaoshu %></font> 条(当前短信条数=短信总条数-只计发送成功条数）</span>
            </td>
       </tr>
        <tr class="tdbg">
	        <td class="lefttd" >收件人选择：</td>
	       <td class="tag_left" style="line-height:32px">
               <input type="radio" name="sendtype" value="0"  onclick="jQuery('#class').hide();"/>所有学员(<span style="color:red"><%=DataFactory.GetOnlyValue("select count(userId) From KS_User Where GroupID<>3 And GroupID<>4 And schoolID="+__user.UserID) %></span>人)<br />
               <input type="radio" name="sendtype" value="1"  onclick="jQuery('#class').show();"/>指定班级 
                    <div  id="class" style="display:none;" >
                        <select name="classid"> 
                    <%
          using (DataTable dt = DataFactory.GetDataTable("select roomid,title  from KS_CosClassRoom where (inputer='" + new TemporaryVar().UserName + "' or schoolID=" + new TemporaryVar().UserID +")"+  ((Utils.StrToInt(KSCMS.S("courseid")) == 0 ? "" : " and CourseIDs like '%" + Utils.StrToInt(KSCMS.S("courseid"))+"%'")) ))
          {
              if (dt.Rows.Count > 0)
              {
                  foreach (DataRow dr in dt.Rows)
                  {
                      KSCMS.W(@"<option value='" + dr["roomid"].ToString() + "'>" + dr["title"].ToString() + "(人数：" + DataFactory.GetOnlyValue("select count(1) from [KS_CosClassStudent] where [RoomID]=" + Utils.StrToInt(dr["roomid"].ToString())) + ")" + "</option>");
                  }
              }
              else
              {
                  KSCMS.W(@"<option value=0>暂无班级</option>");
              }
          }
                         %>
                </select>
                    </div><br />
                 <input type="radio" name="sendtype" value="2" onclick="jQuery('#class').hide();" /><%=Utils.StrToInt(KSCMS.S("courseid"))==0?"购买过我的产品（已付款：":"已购买本课程（已付款：" %><span style="color:red"><%=DataFactory.GetOnlyValue(" select count(distinct(b.UserID)) from KS_COSOrder a  inner join KS_COSOrderItem b on a.OrderID=b.OrderID where b.Business='"+__user.UserName+"' and a.Status=1  "+(Utils.StrToInt(KSCMS.S("courseid"))==0?"":" and b.courseid="+Utils.StrToInt(KSCMS.S("courseid")))) %></span>人)<br />
                 <input type="radio" name="sendtype" value="3" onclick="jQuery('#class').hide();" /><%=Utils.StrToInt(KSCMS.S("courseid"))==0?"购买过我的产品（未付款：":"已购买本课程（未付款：" %><span style="color:red"><%=DataFactory.GetOnlyValue(" select count(distinct(b.UserID)) from KS_COSOrder a  inner join KS_COSOrderItem b on a.OrderID=b.OrderID where b.Business='"+__user.UserName+"' and a.Status=0  "+(Utils.StrToInt(KSCMS.S("courseid"))==0?"":" and b.courseid="+Utils.StrToInt(KSCMS.S("courseid")))) %></span>人)<br />
                 <input type="radio" name="sendtype" value="4" onclick="jQuery('#class').hide();" checked />指定学员
                <input type="text" name="ToUserName" id="Text1" maxlength="220" class="textbox" value="" /><font color=red>*</font> 
                <span class="tips">多个收件人请用英文逗号隔开。</span>
                </td>
        </tr>
        <tr class="tdbg">
	        <td class="lefttd">短信内容：</td>
	        <td class="tag_left">
            <textarea name="MsgContent" rows="3" cols="3" id="MsgContent" style="width:95%;height:150px">亲爱的{#RealName},{#Sex}！直播课即于{#SendDate}开始，请准备参加！{#SiteName}</textarea>
            </td>
        </tr>
        <tr class="tdbg">
         <td class="lefttd"></td>
         <td height="50" class="tag_left">  
             <input type="submit" ID="Submit1" class="ty_button button" value="发 送" onclick="return (CheckForm())"   style="margin-left:0" /></td>
        </tr>
        </table>   
       <br />
    </form>
    <%}else if(KSCMS.S("type")=="3"){ %>
    <form name="myform" action="{$GetCurrUrl}" method="post" >
     <input type="hidden" name="action" value="youjian"/>
    <table width="98%" class="border nowhiteSpace" align="center" border=0 >
       <tr class="title">
            <td colspan="2" style="text-align:left">发送邮件<%if(Utils.StrToInt(KSCMS.S("courseid"))!=0){ %>(指定课程：<%=DataFactory.GetOnlyValue("select top 1 name from KS_Course where courseid="+Utils.StrToInt(KSCMS.S("courseid"))) %>下的学员信息 )<%} %></td>
       </tr>
        <tr class="tdbg">
	        <td class="lefttd" >收件人选择：</td>
	        <td class="tag_left " style="line-height:32px" >
               <input type="radio" name="sendtype" value="0"  onclick="jQuery('#class').hide();"/>所有学员(<span style="color:red"><%=DataFactory.GetOnlyValue("select count(userId) From KS_User Where GroupID<>3 And GroupID<>4 And schoolID="+__user.UserID) %></span>人)<br />
               <input type="radio" name="sendtype" value="1"  onclick="jQuery('#class').show();"/>指定班级 
                    <div  id="class" style="display:none;" >
                        <select name="classid"> 
                    <%
          using (DataTable dt = DataFactory.GetDataTable("select roomid,title  from KS_CosClassRoom where (inputer='" + new TemporaryVar().UserName + "' or schoolID=" + new TemporaryVar().UserID +")"+  ((Utils.StrToInt(KSCMS.S("courseid")) == 0 ? "" : " and CourseIDs like '%" + Utils.StrToInt(KSCMS.S("courseid"))+"%'")) ))
          {
              if (dt.Rows.Count > 0)
              {
                  foreach (DataRow dr in dt.Rows)
                  {
                      KSCMS.W(@"<option value='" + dr["roomid"].ToString() + "'>" + dr["title"].ToString() + "(人数：" + DataFactory.GetOnlyValue("select count(1) from [KS_CosClassStudent] where [RoomID]=" + Utils.StrToInt(dr["roomid"].ToString())) + ")" + "</option>");
                  }
              }
              else
              {
                  KSCMS.W(@"<option value=0>暂无班级</option>");
              }
          }
                         %>
                </select>
                    </div><br />
                 <input type="radio" name="sendtype" value="2" onclick="jQuery('#class').hide();" /><%=Utils.StrToInt(KSCMS.S("courseid"))==0?"购买过我的产品（已付款：":"已购买本课程（已付款：" %><span style="color:red"><%=DataFactory.GetOnlyValue(" select count(distinct(b.UserID)) from KS_COSOrder a  inner join KS_COSOrderItem b on a.OrderID=b.OrderID where b.Business='"+__user.UserName+"' and a.Status=1  "+(Utils.StrToInt(KSCMS.S("courseid"))==0?"":" and b.courseid="+Utils.StrToInt(KSCMS.S("courseid")))) %></span>人)<br />
                 <input type="radio" name="sendtype" value="3" onclick="jQuery('#class').hide();" /><%=Utils.StrToInt(KSCMS.S("courseid"))==0?"购买过我的产品（未付款：":"已购买本课程（未付款：" %><span style="color:red"><%=DataFactory.GetOnlyValue(" select count(distinct(b.UserID)) from KS_COSOrder a  inner join KS_COSOrderItem b on a.OrderID=b.OrderID where b.Business='"+__user.UserName+"' and a.Status=0  "+(Utils.StrToInt(KSCMS.S("courseid"))==0?"":" and b.courseid="+Utils.StrToInt(KSCMS.S("courseid")))) %></span>人)<br />
                 <input type="radio" name="sendtype" value="4" onclick="jQuery('#class').hide();" checked />指定学员
                <input type="text" name="ToUserName" id="Text2" maxlength="220" class="textbox" value="" /><font color=red>*</font> 
                <span class="tips">多个收件人请用英文逗号隔开。</span>
                </td>
        </tr>
        <tr class="tdbg">
	        <td class="lefttd">邮件主题：</td>
	        <td class="tag_left">
                <input type="text" name="Subject" id="Text3" maxlength="220" class="textbox" value=""/><font color=red>*</font> 
                </td>
        </tr>
        <tr class="tdbg">
	        <td class="lefttd">邮件内容：   </td>
	        <td class="tag_left">
            <textarea name="MsgContent" rows="3" cols="3" id="MsgContent" style="width:95%;height:150px"></textarea>
             <%Kesion.APPCode.EditorAPI.EchoEditor("editor", "MsgContent", "Common",0,true,true,true,false,false);%>
            </td>
        </tr>
        <tr>
            <td class="lefttd">发件人：</td>
            <td class="tag_left"><input type="text" name="Sender" class="textbox" value="<%=__user.UserName %>" /></td>
        </tr>
        <tr>
            <td class="lefttd">发件人Email：</td>
            <td class="tag_left"><input type="text" name="SenderMail" class="textbox" value="<%=__user.Email %>" /></td>
        </tr>
        <tr class="tdbg">
         <td class="lefttd"></td>
         <td height="50" class="tag_left">  <input type="submit" ID="Submit2" class="ty_button button" value="发 送" onclick="return (CheckForm())"  / style="margin-left:0"></td>
        </tr>
        </table>   
       <br />
    </form>
    <%}else if(KSCMS.S("courseid")!=""){ %>
    <div class="type-choice">
   <label>请选择发送通知类型：</label>
    <a href="<%=BasicField.GetUserUrl("teacher/tcsendinfo","type-1,courseid-"+KSCMS.S("courseid")+",coursetype-"+KSCMS.S("coursetype")) %>" onclick="return(confirm('确定选择此项么？'))">站内信息</a>
    <a href="<%=BasicField.GetUserUrl("teacher/tcsendinfo","type-2,courseid-"+KSCMS.S("courseid")+",coursetype-"+KSCMS.S("coursetype")) %>" onclick="return(confirm('确定选择此项么？'))">短信</a>
    <a href="<%=BasicField.GetUserUrl("teacher/tcsendinfo","type-3,courseid-"+KSCMS.S("courseid")+",coursetype-"+KSCMS.S("coursetype")) %>" onclick="return(confirm('确定选择此项么？'))">邮件</a>
    </div>
    <%} %>
    
        <div style="line-height:28px; color:#666;padding:0 20px">
            <strong>可以在发送的内容里使用以下标签：</strong>
            <br />
            可用标签：用户名 -{#UserName}  姓名 - {#RealName} 先生或是女士 - {#Sex}  网站名称 - {#SiteName} 发送时间 - {#SendTime}  发送日期 -{#SendDate}
            <br /><strong>操作小贴士</strong><br />
            <p style="color:#999">
            ① 发布信息,请严格遵守法律法规。对于不按要求发布的用户，我们将锁定账户处理；<br />
            ② 可以用英文状态下的逗号将用户名隔开实现群发；<br />
            <%if (KSCMS.S("type")=="2") { %>
            ③ 账户的短信余额不足时，将无法使用短信群发功能；<br />
            ④ 发送短信信息时请注意字数，每<%=__configinfo.G3ContetnLength %>个字算一条条短信；
            <%} %>
            </p>
 		</div>

</div>
<% } %>

